/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.quests.quest.area;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import dev.toma.gunsrpg.common.quests.quest.area.IMobSpawnProcessor;
import dev.toma.gunsrpg.common.quests.quest.area.IMobSpawnProcessorSerializer;
import dev.toma.gunsrpg.common.quests.quest.area.IMobTargettingContext;
import dev.toma.gunsrpg.common.quests.quest.area.MobSpawnProcessorType;
import dev.toma.gunsrpg.util.helper.JsonHelper;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class SetEquipmentProcessor
implements IMobSpawnProcessor {
    private final MobSpawnProcessorType<SetEquipmentProcessor> type;
    private final Map<EquipmentSlotType, Item> equipment;

    public SetEquipmentProcessor(MobSpawnProcessorType<SetEquipmentProcessor> type, Map<EquipmentSlotType, Item> equipment) {
        this.type = type;
        this.equipment = equipment;
    }

    @Override
    public MobSpawnProcessorType<?> getType() {
        return this.type;
    }

    @Override
    public void processMobSpawn(LivingEntity entity, IMobTargettingContext targettingContext) {
        for (Map.Entry<EquipmentSlotType, Item> entry : this.equipment.entrySet()) {
            EquipmentSlotType slotType = entry.getKey();
            Item item = entry.getValue();
            ItemStack itemStack = new ItemStack((IItemProvider)item, 1);
            entity.func_184201_a(slotType, itemStack);
        }
    }

    public static final class Serializer
    implements IMobSpawnProcessorSerializer<SetEquipmentProcessor> {
        @Override
        public SetEquipmentProcessor deserialize(MobSpawnProcessorType<SetEquipmentProcessor> type, JsonElement element) throws JsonParseException {
            JsonObject object = JsonHelper.asJsonObject(element);
            JsonObject equipment = JSONUtils.func_152754_s((JsonObject)object, (String)"equipment");
            EnumMap<EquipmentSlotType, Item> equipmentMap = new EnumMap<EquipmentSlotType, Item>(EquipmentSlotType.class);
            Set entrySet = equipment.entrySet();
            for (Map.Entry entry : entrySet) {
                EquipmentSlotType slotType;
                try {
                    slotType = EquipmentSlotType.valueOf((String)((String)entry.getKey()).toUpperCase());
                }
                catch (Exception e) {
                    throw new JsonSyntaxException("Unknown equipment slot type: " + (String)entry.getKey());
                }
                ResourceLocation itemId = new ResourceLocation(((JsonElement)entry.getValue()).getAsString());
                Item item = (Item)ForgeRegistries.ITEMS.getValue(itemId);
                equipmentMap.put(slotType, item);
            }
            return new SetEquipmentProcessor(type, equipmentMap);
        }

        @Override
        public void toNbt(SetEquipmentProcessor processor, CompoundNBT nbt) {
            ListNBT list = new ListNBT();
            for (Map.Entry entry : processor.equipment.entrySet()) {
                CompoundNBT data = new CompoundNBT();
                data.func_74778_a("slotType", ((EquipmentSlotType)entry.getKey()).name());
                data.func_74778_a("item", ((Item)entry.getValue()).getRegistryName().toString());
                list.add((Object)data);
            }
            nbt.func_218657_a("equipment", (INBT)list);
        }

        @Override
        public SetEquipmentProcessor fromNbt(MobSpawnProcessorType<SetEquipmentProcessor> type, CompoundNBT nbt) {
            ListNBT list = nbt.func_150295_c("equipment", 10);
            EnumMap<EquipmentSlotType, Item> map = new EnumMap<EquipmentSlotType, Item>(EquipmentSlotType.class);
            list.forEach(inbt -> {
                CompoundNBT data = (CompoundNBT)inbt;
                EquipmentSlotType slotType = EquipmentSlotType.valueOf((String)data.func_74779_i("slotType"));
                ResourceLocation itemId = new ResourceLocation(data.func_74779_i("item"));
                Item item = (Item)ForgeRegistries.ITEMS.getValue(itemId);
                map.put(slotType, item);
            });
            return new SetEquipmentProcessor(type, map);
        }
    }
}

